SET SQL_SAFE_UPDATES=0;
SET @enqVelRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_VELOCITY_RECIPIENTS');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS PARENT_FIRSTNAME,
    T1.lastName AS PARENT_LASTNAME,
    T2.studentFirstName AS STUDENT_FIRSTNAME,
    T2.studentLastName AS STUDENT_LASTNAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneNo AS MOBILE_NO,
    T1.phoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
	T4.academyid AS ACADEMY_ID,
	T4.locationid AS LOCATION_ID,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL    
FROM
    enquiry T1
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    admission_enq_details T3 ON T3.enqStudentDetailsId = T2.id
        LEFT JOIN
    academy_location T4 ON T4.id = T3.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    T1.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "STUDENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "STUDENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "locationId",
            "resultKey": "LOCATION_ID",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
}' WHERE (`dataProviderId` = @enqVelRecId);

-- Enquiry Appointment Recipient

SET @enqAppRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_APPOINTMENT_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    sg.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS PARENT_FIRSTNAME,
    T1.lastName AS PARENT_LASTNAME,
    T2.studentFirstName AS FIRST_NAME,
    T2.studentLastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
	concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T2.mobileCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    enquiry T1 ON T1.id = sg.enquiryId
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    sg.id IN (namedParams) and sg.isAppointeeAppointment = TRUE",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 9
        }
    ]
}' WHERE (`dataProviderId` = @enqAppRecId);

-- ENQUIRY_REMINDER_TO_SCHEDULE_AN_APPOINTMENT_PARENT_RECIPIENT

SET @enqRemAppRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_REMINDER_TO_SCHEDULE_AN_APPOINTMENT_PARENT_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T2.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T2.fatherFirstName AS PARENT_FIRSTNAME,
    T2.fatherLastName AS PARENT_LASTNAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    T2.fatherEmailId AS EMAIL_ID,
    T2.fatherPhoneNo AS MOBILE_NO,
    T2.fatherPhoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
	(Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    enquiry T1 
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
		LEFT JOIN
    organizations org on org.id = (select max(id) from organizations)
WHERE
    T2.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "fatherFirstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "fatherLastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },		 
		{
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },{
            "id": 10,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 12
        }
    ]
}' WHERE (`dataProviderId` = @enqRemAppRecId);

-- ENQUIRY_REMINDER_TO_APPLY_RECIPIENT

SET @enqRemApplyRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_REMINDER_TO_APPLY_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T2.fatherFirstName AS PARENT_FIRSTNAME,
    T2.fatherLastName AS PARENT_LASTNAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T6.addressText,' ',T7.cityName,', ',T8.countryName,', ',T9.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T6.phoneCountryCode,'-',T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T6.websiteURL AS WEBSITE_URL,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
	concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneNo AS MOBILE_NO,
    T1.phoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    enquiry T1 
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
		LEFT OUTER JOIN
	city T7 ON T7.id = T6.cityId
		LEFT OUTER JOIN
	country T8 ON T8.id = T7.countryId
		LEFT OUTER JOIN
	country_region T9 ON T9.id = T7.countryRegionId
        LEFT JOIN
    organizations org on org.id = (select max(id) from organizations)
WHERE
    T1.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "fatherFirstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "fatherLastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "addressText",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 15
        }
    ]
}' WHERE (`dataProviderId` = @enqRemApplyRecId);

-- ENQUIRY_REMINDER_TO_APPLY_PARENT_RECIPIENT

SET @enqRemApplyParRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_REMINDER_TO_APPLY_PARENT_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T2.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T2.fatherFirstName AS PARENT_FIRSTNAME,
    T2.fatherLastName AS PARENT_LASTNAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
	concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    T2.fatherEmailId AS EMAIL_ID,
    T2.fatherPhoneNo AS MOBILE_NO,
    T2.fatherPhoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    enquiry T1 
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT JOIN
    organizations org on org.id = (select max(id) from organizations)
WHERE
    T2.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "fatherFirstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "fatherLastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },{
            "id": 10,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 12
        }
    ]
}' WHERE (`dataProviderId` = @enqRemApplyParRecId);

-- SUBMIT_APPLICATION_PAY_LATER_BUZZ_RECIPIENT

SET @subAppPayLaterRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_LATER_BUZZ_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
	T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
     ml.`code` as LANGUAGE_KEY,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T8.id
        LEFT OUTER JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
		LEFT OUTER JOIN
	multi_language ml ON ml.id = T4.correspondence_language
		LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 11
        },       
        {
            "id": 13,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 14
        }
    ]
}' WHERE (`dataProviderId` = @subAppPayLaterRecId);

-- SUBMIT_APPLICATION_RECIPIENTS

SET @subApplicationRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_RECIPIENTS');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
        T1.id AS ID,
        T3.`salutationName` AS SALUTATION_NAME,
        T8.`salutationName` AS PARENT_SALUTATION_NAME,
        T2.`firstName` AS FIRST_NAME,
        T2.`middleName` AS MIDDLE_NAME,
		T2.`printName` AS STUDENT_PRINT_NAME,
        T2.`lastName` AS LAST_NAME,
        T7.`emailId` AS EMAIL_ID,
        T7.`mobileNumber` AS MOBILE_NO,
        T1.`code` AS APPLICATION_CODE,
        T7.`firstName` AS PARENT_FIRSTNAME,
        T7.`lastName` AS PARENT_LASTNAME,
		T7.`printName` AS PARENT_PRINT_NAME,
        T7.`mobileCountryCode` AS MOBILE_CODE  ,
        ml.`code` as LANGUAGE_KEY
    FROM
        application T1
            LEFT OUTER JOIN
        applicant_person T2 ON T1.applicantPersonId = T2.id
            LEFT JOIN
        salutations T3 ON T3.id = T2.salutationId
            LEFT OUTER JOIN
        external_user_association T5 ON T5.applicationId = T1.id
            LEFT OUTER JOIN
        external_users T4 ON T4.id = T5.externalUserId
            LEFT OUTER JOIN
        applicant_person_relationships T6 ON T6.applicantPersonId = T2.id
            LEFT OUTER JOIN
        applicant_person T7 ON T7.id = T6.relatedApplicantPersonId
            LEFT JOIN
        salutations T8 ON T8.id = T7.salutationId
         LEFT JOIN
        multi_language ml on ml.id = T2.correspondence_language
    WHERE
        T1.id IN (namedParams)
            AND T6.relationship = 'FATHER'
            ",
    `jsonString` ='{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 3,
                "value": "firstName",
                "resultKey": "FIRST_NAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "middleName",
                "resultKey": "MIDDLE_NAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "lastName",
                "resultKey": "LAST_NAME",
                "displayCode": "",
                "displayOrder": 4
            },
            {
                "id": 6,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 5
            },
            {
                "id": 7,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 6
            },
            {
                "id": 8,
                "value": "code",
                "resultKey": "APPLICATION_CODE",
                "displayCode": "",
                "displayOrder": 7
            },		 
    		{
                "id": 9,
                "value": "firstName",
                "resultKey": "PARENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 8
            },
    		{
                "id": 10,
                "value": "lastName",
                "resultKey": "PARENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 9
            },
    		{
                "id": 11,
                "value": "salutationName",
                "resultKey": "PARENT_SALUTATION_NAME",
                "displayCode": "",
                "displayOrder": 10
            },
    		{
                "id": 12,
                "value": "salutationName",
                "resultKey": "SALUTATION_NAME",
                "displayCode": "",
                "displayOrder": 11
            },
    		{
                "id": 13,
                "value": "shortName",
                "resultKey": "STUDENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 12
            },
    		{
                "id": 14,
                "value": "shortName",
                "resultKey": "PARENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 13
            },       
			{
				"id": 15,
				"value": "primaryeEmailId",
				"resultKey": "ACADEMY_EMAIL",
				"displayCode": "",
				"displayOrder": 14
			},
			{
				"id": 16,
				"value": "websiteURL",
				"resultKey": "WEBSITE_URL",
				"displayCode": "",
				"displayOrder": 15
			},
			{
				"id": 17,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 16
			}
        ]
    }' WHERE (`dataProviderId` = @subApplicationRecId);

-- SUBMIT_APPLICATION_PAY_NOW_BUZZ_RECIPIENT

SET @subAppPayNowRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_NOW_BUZZ_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T13.addressText,' ',T14.cityName,', ',T15.countryName,', ',T16.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T13.phoneCountryCode,'-',T13.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T13.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T8.academyName AS ACADEMY_NAME,
    T9.programName AS PROGRAM_NAME,
    T11.batchName AS BATCH_NAME,
    T19.printName AS LEAD_OWNER_NAME,
    T19.emailId AS OWNER_EMAIL_ID,
    T13.primaryeEmailId AS ACADEMY_EMAIL,
    T13.websiteURL AS WEBSITE_URL,
    concat(T13.phoneCountryCode,'-',T13.phoneAreaCode,'-',T13.phoneNo) AS PHONE_NUMBER,
    CONCAT(T19.mobileCountryCode,
            ' ',
            T19.mobileNumber) AS OWNER_MOBILE_NO,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
      (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
	programs T9 ON T9.id = T7.programId
		LEFT JOIN
batches T11 ON T11.programId=T9.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T12 ON T12.academyLocationId = T8.id
		LEFT OUTER JOIN
    address T13 ON T13.id = T12.addressId && T13.addressTypeId=10
		LEFT OUTER JOIN
	city T14 ON T14.id = T13.cityId
		LEFT OUTER JOIN
	country T15 ON T15.id = T14.countryId
		LEFT OUTER JOIN
	country_region T16 ON T16.id = T14.countryRegionId
		LEFT OUTER JOIN
    users T17 ON T17.id = T3.applicationOwner
        LEFT JOIN
    staffs T18 ON T18.userId = T17.id
        LEFT JOIN
    persons T19 ON T19.id = T18.personId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams) group by T1.id",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },{
            "id": 6,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "addressText",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "batchName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "printName",
            "resultKey": "LEAD_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "emailId",
            "resultKey": "OWNER_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "mobileNumber",
            "resultKey": "OWNER_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 18
        },       
			{
				"id": 20,
				"value": "primaryeEmailId",
				"resultKey": "ACADEMY_EMAIL",
				"displayCode": "",
				"displayOrder": 19
			},
			{
				"id": 21,
				"value": "websiteURL",
				"resultKey": "WEBSITE_URL",
				"displayCode": "",
				"displayOrder": 20
			},
			{
				"id": 22,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 21
			}
    ]
}' WHERE (`dataProviderId` = @subAppPayNowRecId);

-- SUBMIT_APPLICATION_PAY_NOW_BUZZ_PARENT_RECIPIENT

SET @subAppPayNowParRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_NOW_BUZZ_PARENT_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T6.`emailId` AS EMAIL_ID,
    T6.`mobileNumber` AS MOBILE_NO,
    T6.`mobileCountryCode` AS MOBILE_CODE,
    T6.`firstName` AS PARENT_FIRSTNAME,
    T6.`lastName` AS PARENT_LASTNAME,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T13.addressText,' ',T14.cityName,', ',T15.countryName,', ',T16.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T13.phoneCountryCode,'-',T13.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T13.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T13.primaryeEmailId AS ACADEMY_EMAIL,
    T13.websiteURL AS WEBSITE_URL,
    concat(T13.phoneCountryCode,'-',T13.phoneAreaCode,'-',T13.phoneNo) AS PHONE_NUMBER,
    T8.academyName AS ACADEMY_NAME,
    T9.programName AS PROGRAM_NAME,
    T11.batchName AS BATCH_NAME,
    T19.printName AS LEAD_OWNER_NAME,
    T19.emailId AS OWNER_EMAIL_ID,
    CONCAT(T19.mobileCountryCode,
            ' ',
            T19.mobileNumber) AS OWNER_MOBILE_NO,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case when T8.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id AND T5.relationship = 'FATHER'
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
        LEFT JOIN
    application_program T7 ON T7.applicationId = T3.id
		LEFT OUTER JOIN
	programs T9 ON T9.id = T7.programId
		LEFT JOIN
    prog_batch_seat_config T10 ON T10.id=T7.progBatchSeatConfigId
		LEFT JOIN
    batches T11 ON T11.id=T10.programBatchId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T12 ON T12.academyLocationId = T8.id
		LEFT OUTER JOIN
    address T13 ON T13.id = T12.addressId && T13.addressTypeId=10
		LEFT OUTER JOIN
	city T14 ON T14.id = T13.cityId
		LEFT OUTER JOIN
	country T15 ON T15.id = T14.countryId
		LEFT OUTER JOIN
	country_region T16 ON T16.id = T14.countryRegionId
		LEFT OUTER JOIN
    users T17 ON T17.id = T3.applicationOwner
        LEFT JOIN
    staffs T18 ON T18.userId = T17.id
        LEFT JOIN
    persons T19 ON T19.id = T18.personId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams) group by T1.id",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },{
            "id": 6,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "addressText",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },		
        {
            "id": 14,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "batchName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "printName",
            "resultKey": "LEAD_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "emailId",
            "resultKey": "OWNER_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "mobileNumber",
            "resultKey": "OWNER_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 19
        },
		{
				"id": 21,
				"value": "primaryeEmailId",
				"resultKey": "ACADEMY_EMAIL",
				"displayCode": "",
				"displayOrder": 20
			},
			{
				"id": 22,
				"value": "websiteURL",
				"resultKey": "WEBSITE_URL",
				"displayCode": "",
				"displayOrder": 21
			},
			{
				"id": 23,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 22
			},
			{
            "id": 24,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 23
        }
    ]
}' WHERE (`dataProviderId` = @subAppPayNowParRecId);

--  PROGRAM_WISE_APPLICATION_APPROVAL_INFO

SET @progAppApprovalId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROGRAM_WISE_APPLICATION_APPROVAL_INFO');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T5.id AS ID,
    T6.code AS APPLICATION_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
	T13.primaryeEmailId AS ACADEMY_EMAIL,
    T13.websiteURL AS WEBSITE_URL,
    concat(T13.phoneCountryCode,'-',T13.phoneAreaCode,'-',T13.phoneNo) AS PHONE_NUMBER,
    ml.code as LANGUAGE_KEY,
	(Case when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL,
    (Case when T8.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T8.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.footerUrl)
	else NULL end) as FOOTER_URL,
    DATE_FORMAT(T11.admissionOfferStartDate, '%d/%m/%Y') AS ADMISSION_OFFER_START_DATE
FROM
    application_program T5
        LEFT JOIN
    application T6 ON T6.id = T5.applicationId
        LEFT JOIN
    applicant_person T7 ON T7.id = T6.applicantPersonId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
    LEFT JOIN
    academy_location_addresses T12 ON T12.academyLocationId = T8.id
        LEFT JOIN
    address T13 ON T13.id = T12.addressId AND T13.addressTypeId = 10
		LEFT JOIN
    organizations org on org.id = 1
    LEFT JOIN
  prog_batch_seat_config T9 on T5.progBatchSeatConfigId = T9.id
    LEFT JOIN
  program_selection_process T10 on T10.programBatchSeatConfigId = T5.progBatchSeatConfigId
    LEFT JOIN
  prog_slctn_process_admisn_conf T11 on T11.programSelectionProcessId = T10.id
        LEFT JOIN
    multi_language ml on T7.correspondence_language=ml.id
WHERE
    T5.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "admissionOfferStartDate",
            "resultKey": "ADMISSION_OFFER_START_DATE",
            "displayCode": "",
            "displayOrder": 8
        },       
        {
            "id": 10,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 11
        }]
}' WHERE (`dataProviderId` = @progAppApprovalId);

--  APPLICATION_APPROVAL_PARENT_GUARDIAN_RECIPIENT

SET @appApprovalParRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_APPROVAL_PARENT_GUARDIAN_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T3.id AS ID,
	T3.`code` AS APPLICATION_CODE,
    T4.`firstName` AS FIRST_NAME,
	T4.`middleName` AS MIDDLE_NAME,
    T4.`lastName` AS LAST_NAME,
    T6.`emailId` AS EMAIL_ID,
    T6.`mobileNumber` AS MOBILE_NO,
    T6.`mobileCountryCode` AS MOBILE_CODE,
    T6.`firstName` AS PARENT_FIRSTNAME,
    T6.`lastName` AS PARENT_LASTNAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
	T10.primaryeEmailId AS ACADEMY_EMAIL,
    T10.websiteURL AS WEBSITE_URL,
    concat(T10.phoneCountryCode,'-',T10.phoneAreaCode,'-',T10.phoneNo) AS PHONE_NUMBER,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    application T3
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
        LEFT JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
     LEFT OUTER JOIN
    academy_location_addresses T9 ON T9.academyLocationId = T8.id
        LEFT OUTER JOIN
    address T10 ON T10.id = T9.addressId AND T10.addressTypeId = 10
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
        LEFT JOIN    
     multi_language ml on T4.correspondence_language=ml.id        
 where T3.id in(namedParams)
		and T5.relationship = 'FATHER'
        and T5.whetherDeleted = false",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
		{
            "id": 2,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
 		{
            "id": 7,
            "value": "mobileNo",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "mobileCode",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
 		{
            "id": 9,
            "value": "parentFirstname",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 8
        },
 		{
            "id": 10,
            "value": "parentLastname",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 10
        },
 		{
            "id": 12,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 14
        },       
        {
            "id": 16,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "phoneNo",
            "resultKey": "PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 17
        }
    ]}' WHERE (`dataProviderId` = @appApprovalParRecId);

--  PROGRAM_WISE_APPLICATION_REJECT_INFO

SET @progAppRejectId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROGRAM_WISE_APPLICATION_REJECT_INFO');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T5.id AS ID,
    T6.code AS APPLICATION_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    ml.code as LANGUAGE_KEY,
	(Case when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL,
    (Case when T8.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T8.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.footerUrl)
	else NULL end) as FOOTER_URL,
	T9.value AS REASON_REJECTION
FROM
    application_program T5
        LEFT JOIN
    application T6 ON T6.id = T5.applicationId
        LEFT JOIN
    applicant_person T7 ON T7.id = T6.applicantPersonId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
		LEFT JOIN
    application_prog_rejection_reasons T9 ON T9.id = T5.rejection_reason_id
		LEFT JOIN
    organizations org on org.id = 1
        LEFT JOIN
    multi_language ml on T7.correspondence_language=ml.id
WHERE
    T5.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "value",
            "resultKey": "REASON_REJECTION",
            "displayCode": "",
            "displayOrder": 8
        },       
			{
				"id": 10,
				"value": "primaryeEmailId",
				"resultKey": "ACADEMY_EMAIL",
				"displayCode": "",
				"displayOrder": 9
			},
			{
				"id": 11,
				"value": "websiteURL",
				"resultKey": "WEBSITE_URL",
				"displayCode": "",
				"displayOrder": 10
			},
			{
				"id": 12,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 11
			}]
}' WHERE (`dataProviderId` = @progAppRejectId);

--   APPOINTMENT_RECIPIENT

SET @appointmentRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,    
    T1.`appointeeName` AS PRINT_NAME,
    T1.`appointeeEmailId` AS EMAIL_ID,
    (Case
        when T3.code is null then enq.code
        else T3.code
    end) as ENQ_CODE,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(substring_index(personToMeet, '/', -1)) as PERSON_TO_MEET, 
    TRIM(substring_index(appointeeContactNo, '-', 1)) as MOBILE_CODE, 
    TRIM(substring_index(appointeeContactNo, '-', -1)) as MOBILE_NO,
    TRIM(substring_index(appointeeName, '/', -1)) as FIRST_NAME,
    T2.academyName AS ACADEMY_NAME,
    T2.locationName AS LOCATION_NAME,
    T2.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    (Case 
    when T2.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T2.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T2.logoUrl)end) as LOGO_URL,
    (Case when T2.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.headerUrl) 
    else NULL end) as HEADER_URL,
	(Case when T2.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.footerUrl) 
    else NULL end) as FOOTER_URL,
    CONCAT(T6.addressText,' ',T14.cityName,', ',T15.countryName,', ',T16.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
     CONCAT(T6.phoneCountryCode,'-',T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
	T19.printName AS LEAD_OWNER_NAME,
	T19.printName AS OWNER_NAME,
    T19.emailId AS OWNER_EMAIL_ID,
    CONCAT(T19.mobileCountryCode,
            ' ',
            T19.mobileNumber) AS OWNER_MOBILE_NO
FROM
    sg_appointment T1
        LEFT JOIN
    academy_location T2 ON T2.id = T1.academyLocationId
		LEFT JOIN
    application T3 ON T3.id = T1.applicationId
   		LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T2.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
		LEFT OUTER JOIN
	city T14 ON T14.id = T6.cityId
		LEFT OUTER JOIN
	country T15 ON T15.id = T14.countryId
		LEFT OUTER JOIN
	country_region T16 ON T16.id = T14.countryRegionId
	LEFT OUTER JOIN
    users T17 ON T17.id = T3.applicationOwner
        LEFT JOIN
    staffs T18 ON T18.userId = T17.id
        LEFT JOIN
    persons T19 ON T19.id = T18.personId
		LEFT JOIN
    organizations org on org.id = 1
		LEFT JOIN
    enquiry enq on enq.id = T1.enquiryId	
WHERE
    T1.id IN (namedParams) and T1.isAppointeeAppointment = TRUE",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "FIRST_NAME",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "PERSON_TO_MEET",
            "resultKey": "PERSON_TO_MEET",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "appointeeName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },        
        {
            "id": 6,
            "value": "APPOINTMENT_DATE",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "addressText",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "printName",
            "resultKey": "OWNER_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "code",
            "resultKey": "ENQ_CODE",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "printName",
            "resultKey": "LEAD_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "emailId",
            "resultKey": "OWNER_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "mobileNumber",
            "resultKey": "OWNER_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 19
        },
		{
				"id": 21,
				"value": "primaryeEmailId",
				"resultKey": "ACADEMY_EMAIL",
				"displayCode": "",
				"displayOrder": 20
			},
			{
				"id": 22,
				"value": "websiteURL",
				"resultKey": "WEBSITE_URL",
				"displayCode": "",
				"displayOrder": 21
			},
			{
				"id": 23,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 22
			}
    ]
}' WHERE (`dataProviderId` = @appointmentRecId);

--  APPLICANT_APPOINTMENT_RECIPIENT

SET @appAppointRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    sg.id AS ID,
    T1.code AS APPLICANT_CODE,
    T2.firstName AS FIRST_NAME,
    T2.lastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T2.mobileCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    ml.code as LANGUAGE_KEY,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl)
	else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    application T1 ON T1.id = sg.applicationId
        LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
    LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT  JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
		LEFT JOIN
    organizations org on org.id = 1
        LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id
WHERE
    sg.id IN (namedParams) and sg.isAppointeeAppointment = TRUE",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICANT_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },		 
		{
            "id": 5,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
			{
				"id": 7,
				"value": "websiteURL",
				"resultKey": "WEBSITE_URL",
				"displayCode": "",
				"displayOrder": 6
			},
			{
				"id": 8,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 7
			}
    ]
}' WHERE (`dataProviderId` = @appAppointRecId);

--  REMINDER_TO_PAY_THE_APPLICATION_FEES_RECIPIENT

SET @remPayAppFeeRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REMINDER_TO_PAY_THE_APPLICATION_FEES_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "select 
    T1.id AS ID,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T1.`code` as APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    ml.code as LANGUAGE_KEY,
    (Case
        when
            T8.logoUrl is null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        when
            T8.logoUrl is null
                and org.orgUrl is null
        then
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        else CONCAT(org.orgUrl, '/', T8.logoUrl)
    end) as LOGO_URL,
    (Case
        when
            T8.headerUrl is not null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        else NULL
    end) as HEADER_URL,
    (Case
        when
            T8.footerUrl is not null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL
    end) as FOOTER_URL
from
    application T1
        left outer join
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT OUTER JOIN
    application_program T4 ON T4.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T4.academyLocationId
    LEFT OUTER JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T8.id
        LEFT OUTER JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
          LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id       
 where T1.id in(namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 9
        },       
			{
				"id": 11,
				"value": "primaryeEmailId",
				"resultKey": "ACADEMY_EMAIL",
				"displayCode": "",
				"displayOrder": 10
			},
			{
				"id": 12,
				"value": "websiteURL",
				"resultKey": "WEBSITE_URL",
				"displayCode": "",
				"displayOrder": 11
			},
			{
				"id": 13,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 12
			}
    ]}' WHERE (`dataProviderId` = @remPayAppFeeRecId);

-- ENQUIRY_REMINDER_TO_SCHEDULE_AN_APPOINTMENT_RECIPIENT

SET @enqRemSchAppRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_REMINDER_TO_SCHEDULE_AN_APPOINTMENT_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T2.fatherFirstName AS PARENT_FIRSTNAME,
    T2.fatherLastName AS PARENT_LASTNAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneNo AS MOBILE_NO,
    T1.phoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
	concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    enquiry T1 
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    academy_location T4 ON T4.id = T1.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT JOIN
    organizations org on org.id = (select max(id) from organizations)
WHERE
    T1.id IN (namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "fatherFirstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "fatherLastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 11
        },
			{
				"id": 13,
				"value": "phoneNo",
				"resultKey": "PHONE_NUMBER",
				"displayCode": "",
				"displayOrder": 12
			}
    ]
}' WHERE (`dataProviderId` = @enqRemSchAppRecId);

set SQL_SAFE_UPDATES=1;